%define brcmname bnxt_lfc
%define brcmvers %{LFC_VERSION}
%define brcmfmly NetXtreme
%define brcmwork %{brcmname}-%{brcmvers}

%define debug_package %{nil}

Summary   : Broadcom %{brcmfmly} LFC module driver
Name      : %{brcmname}
Version   : %{brcmvers}
Release   : 0
Vendor    : Broadcom Limited
License   : GPL
Group     : System/Kernel
Source    : %{brcmwork}.tar.gz
BuildRoot : /var/tmp/%{name}-%{version}-%{release}-buildroot

%define brcmfilelist file.list.%{name}

%description
This package contains the Broadcom %{brcmfmly} LFC module driver.

%prep
%setup -T -b 0 -n %{brcmwork}

%build
value=%{?KVER}
if [ -z "$value" ]; then
	KVER=$(uname -r)
else
	KVER=$value
fi
make KVER=$KVER

%install
value=%{?KVER}
if [ -z "$value" ]; then
	KVER=$(uname -r)
else
	KVER=$value
fi

BCM_KVER=`echo $KVER | cut -c1-3 | sed -e 's/\.//'`
if [ $BCM_KVER -gt 24 ];then
	BCM_DRV=%{brcmname}.ko
else
	BCM_DRV=%{brcmname}.o
fi

if [ -d /lib/modules/$KVER/updates ]; then
	BCMDSTDIR=updates
elif [ -f /etc/depmod.conf ]; then
	if grep -q "search.*[[:space:]]updates" /etc/depmod.conf; then
		BCMDSTDIR=updates
	fi
fi
if [ -z "$BCMDSTDIR" -a -d /etc/depmod.d ]; then
	if grep -q "search.*[[:space:]]updates" /etc/depmod.d/*; then
		BCMDSTDIR=updates
	fi
fi
if [ -z "$BCMDSTDIR" ]; then
	BCMDSTDIR=kernel/drivers/char
fi

echo "%defattr(-,root,root)"                           > %{brcmfilelist}

echo "/lib/modules/$KVER/$BCMDSTDIR/$BCM_DRV" >> %{brcmfilelist}
mkdir -p $RPM_BUILD_ROOT/lib/modules/$KVER/$BCMDSTDIR

make install PREFIX=$RPM_BUILD_ROOT KVER=$KVER

%post
depmod -a > /dev/null 2> /dev/null
modprobe bnxt_lfc
exit 0

%postun
depmod -a > /dev/null 2> /dev/null
rmmod bnxt_lfc
exit 0

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{brcmfilelist}

%changelog
*Thu Mar 02 2017 Kshitij Soni <kshitij.soni@broadcom.com> 1.0.4
- Fixed Version number of bnxt_lfc to be corrected reported

*Thu Feb 23 2017 Kshitij Soni <kshitij.soni@broadcom.com> 1.0.3
- Added compatibility and support for various Linux distros.
- Fixed OS crash while executing LFC IOCTL

*Thu Feb 16 2017 Kshitij Soni <kshitij.soni@broadcom.com> 1.0.2
- Fixed OS hang issue when no options are sent in getoption

*Thu Feb 02 2017 Kshitij Soni <kshitij.soni@broadcom.com> 1.0.1
- Implemention of NVM Flush for set option

*Tue Jan 31 2017 Kshitij Soni <kshitij.soni@broadcom.com> 1.0.0
- First release of BNXT_LFC drivers for Linux for LFC feature
